waitForMotionComplete = function()
    while (getQueueSize() > 0) or (isSteady() == false) do
        sync()
    end
end

function createFolder(path)	
    os.execute("mkdir -p "..path)
end

function moveFolder(file,topath)
    os.execute("mv ".. file .. " " .. topath)
end

local function split(str, sep)
    local result = {}
    for item in string.gmatch(str, "([^" .. sep .. "]+)") do
        table.insert(result, item)
    end
    return result
end

function concat_parts(str1, str2)
   local t1 = split(str1, ",")
    local t2 = split(str2, ",")

    local result = {}
 -- 取第二组前12个元素
    local end2 = #t2
    for i = 1, end2 do
        table.insert(result, t2[i])
    end
    -- 取第一组最后6个元素
    local start1 = #t1 - 6 + 1
    for i = start1, #t1 do
        table.insert(result, t1[i])
    end

   

    -- 拼接成逗号分隔字符串
    return table.concat(result, ",")
end

function  parseThreshold(file_name)
    local str = ""
    indx = 0
    local robot_type = getRobotType()
    local robot_subtype = getRobotSubType()  
    local robot_name 
    if robot_subtype == "" or robot_subtype == "10" then
        robot_name = robot_type
    else
        robot_name = robot_type .. "_" .. robot_subtype
    end
    local file = io.open(file_name, "r")
    if file == nil then
        textmsg("碰撞阈值文件为空： ")
         sched.sync_program_point()
         clearNamedVariable("_popup_continue_or_stop")
         do
            local _popup_t = getControlSystemTime()
            popup(TraceLevel.ERROR, "Error", str_cat(table_to_str(robot_name),"的碰撞阈值计算失败,联系研发人员介入"), 1)
            while not variableUpdated("_popup_continue_or_stop", _popup_t) do sync() end
            if not getBool("_popup_continue_or_stop", true) then halt() end
        end
        halt()
    end
    local line = file:read()
    local reps = ","
    local i = 1
    while line do
        indx = indx + 1	   
        string.gsub(line,'[^'..reps..']+',function (w)
              w = string.format("%.6f", (tonumber(w) * 100 + 0.5) /100)
              str = str .. w
              if i ~= 18 then
                  str = str .. ","
              end
              i = i + 1
        end)
        line = file:read()
    end
    if indx ~= 3 then
        textmsg("err: 阈值计算结果为空...")
        sched.sync_program_point()
         clearNamedVariable("_popup_continue_or_stop")
         do
            local _popup_t = getControlSystemTime()
            popup(TraceLevel.ERROR, "Error", str_cat(table_to_str(robot_name),"的碰撞阈值计算失败,联系研发人员介入"), 1)
            while not variableUpdated("_popup_continue_or_stop", _popup_t) do sync() end
            if not getBool("_popup_continue_or_stop", true) then halt() end
        end
        halt()
    end
    return str
end
key = ""
function PrintTable(table , level)
  level = level or 1
  local indent = ""
  for i = 1, level do
    indent = indent.."  "
  end

  if key ~= "" then
    print(indent..key.." ".."=".." ".."{")
  else
    print(indent .. "{")
  end

  key = ""
  for k,v in pairs(table) do
     if type(v) == "table" then
        key = k
        PrintTable(v, level + 1)
     else
        local content = string.format("%s%s = %s", indent .. "  ",tostring(k), tostring(v))
      print(content)  
      end
  end
  print(indent .. "}")

end

function min(a1,b1)
    if(a1>=b1)
    then
        return b1
    else
        return a1
    end
end

function isBufferValid()
    local max_retry_count = 10
    local cnt = 0
    local isValid = pathBufferValid("rec")
    while(not isValid) do
        if(cnt>max_retry_count)
        then
            return -1
        end
        isValid =  pathBufferValid("rec")
        cnt = cnt + 1
        sleep(0.5)
    end
    return 0
end

function parseTraj(file)

    local traj_table = {}
    indx = 0
    local line = file:read()
    local reps = ","
    while line do
        indx = indx + 1
	    local line_table = {} 
        string.gsub(line,'[^'..reps..']+',function (w)
              table.insert(line_table,tonumber(w))
        end)
        traj_table[indx] = line_table
        line = file:read()
    end
    return traj_table
end


function runTraj(traj_name, record_name)

    local file = io.open(traj_name, "r")
    if file == nil then
         textmsg("轨迹文件为空： "..record_name)
         sched.sync_program_point()
         clearNamedVariable("_popup_continue_or_stop")
         do
            local _popup_t = getControlSystemTime()
            popup(TraceLevel.ERROR, "Error", str_cat(table_to_str(robot_type),"的轨迹文件为空,联系研发人员导入"), 1)
            while not variableUpdated("_popup_continue_or_stop", _popup_t) do sync() end
            if not getBool("_popup_continue_or_stop", true) then halt() end
        end
        
        halt()
    end
    local traj = parseTraj(file)

    local traj_sz = #traj
    if(traj_sz == 0)
    then
        print("轨迹文件中的路点数量为0")
        return 0
    else
        print(" 加载的路点数量为: ", traj_sz)
    end
    PrintTable(traj[1],1)
    setSpeedFraction(1.0)
    moveJoint(traj[1], 30 * (3.14 / 180), 30 * (3.14 / 180), 0., 0.)
    waitForMotionComplete()
    print("关节运动到轨迹文件中的第一个路点成功")
   -- start()
   -- tmp, lineno, comment = getPlanContext()
   -- local task_id = newTask()
    --setPlanContext(task_id, lineno, comment)
    pathBufferFree("rec")
    pathBufferAlloc("rec", 2, traj_sz)

    -- 将轨迹文件中的路点分组添加到路径缓存中，
    -- 以10个点为1组，
    -- 如果未添加的路点数量小于或者等于10时，则作为最后一组来添加
    local beg = 0
    while 1 do
        local path_table = {}
        local end_pt = min(10,traj_sz-beg)
        for i=1,end_pt do
            path_table[i] = traj[beg+i]
        end
        pathBufferAppend("rec", path_table)
        beg = beg+10
        if(end_pt<10)
        then 
            break
        end
    end      
    
    local interval = 0.005
    pathBufferEval("rec", getJointMaxAccelerations(),getJointMaxSpeeds(),interval)
    local isBufValid = isBufferValid()
    if(isBufValid==-1)
    then
        print("路径缓存无效，无法进行轨迹运动")
    else
        startRecord(record_name)
        movePathBuffer("rec")
        waitForMotionComplete()

    end
    stopRecord()
    str1 = getRobotType()
    str2 = getRobotSubType()
    if str2 ~= "" and str2 ~= "10" then
        trace_file = str1 .. "_" .. str2 .. "_" .. serial
    else
        trace_file = str1 .. "_" .. serial
    end
    createFolder("/root/.arcs_test/collision_traj_temp/"..trace_file)
    moveFolder("/root/arcs_ws/log/.trace/"..record_name ,"/root/.arcs_test/collision_traj_temp/"..trace_file.."/"..record_name)

  --  stop()
  --  deleteTask(task_id)
end
