function getMaxValue(arr)
    if #arr == 0 then
        return nil  -- 空数组返回nil
    end
    
    local maxVal = arr[1]
    for i = 2, #arr do
        if arr[i] > maxVal then
            maxVal = arr[i]
        end
    end
    return maxVal
end


local laohuaq1 = {-0.8900944451586199,0.7754199448783765,0.8449337445890255,-1.402323799030817,0.5244949971154704,-0.5768120810148624}
local laohuaq2 = {-1.500097632770998,1.468678032144206,1.69941094027469,-0.7901225835097961,1.152255987571724,-1.570954052000511}
local laohuaq3 = {-5.204962099546476e-05,4.898787858396683e-05,5.817310581846062e-05,-3.301225233783409e-05,4.768436448798257e-05,-5.50204205630568e-05}
local laohuaq4 = {1.085406055330484,-1.076851547032759,-1.305141184718867,1.416317325994021,-0.7297101617315598,0.6265652133160159}
local laohuaq5 = {1.507409073649655,-1.459238680289558,-1.796954991762602,0.722440130161161,-1.142462352711499,1.407899201647873}
local laohuaq6 = {6.123484822995854e-06,-6.123484822995854e-06,-6.123484822995854e-06,3.668028037537121e-06,-3.668028037537121e-06,0}
local laohuaq7 = {2.094393975501891,1.570794073012288,2.094393975501891,2.094391052278904,1.570794976756799,1.570794976756799}
local laohuaq8 = {-2.094395102393196,-1.570795199903593,-2.094395102393196,-2.094396452431293,-1.570796326794897,-1.570796326794897}

local collision_traj_q1 = {0,0,0,0,0,0}
local collision_traj_q2 = {1.57,1.57,1.57,1.57,1.57,1.57}
local collision_traj_q3 = {0,0,0,0,0,0}
local collision_traj_q4 = {-1.57,-1.57,-1.57,-1.57,-1.57,-1.57}
local collision_traj_q5 = {0,0,0,0,0,0}


local M_PI = 3.1415926535
local a_joint_max = getJointMaxAccelerations()
local v_joint_max = getJointMaxSpeeds()
local a_tcp = getTcpMaxAccelerations()
local a_tcp_max = a_tcp[1]
local v_tcp = getTcpMaxSpeeds()
local v_tcp_max = v_tcp[1]
local dh = getKinematicsParam(true)

local wingspan = dh.a[3] + dh.a[4] + dh.d[5]


old_filename = "nopayload_timeoptimaloff"
str1 = getRobotType()
str2 = getRobotSubType()
if str2 ~= "" and str2 ~= "10" then
    robot_type = str1 .. "_" .. str2
else
    robot_type = str1
end
local record_name =robot_type  .. "_" .. old_filename .. ".csv"

setTimeOptimalEnable(false)
sleep(0)
moveJoint(collision_traj_q1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
startRecord(record_name)
sleep(2)
moveJoint(collision_traj_q2,0.5 * getMaxValue(a_joint_max),0.5 * getMaxValue(v_joint_max),0.0,0)
moveJoint(collision_traj_q3,0.5 * getMaxValue(a_joint_max),0.5 * getMaxValue(v_joint_max),0.0,0)
moveJoint(collision_traj_q4,0.5 * getMaxValue(a_joint_max),0.5 * getMaxValue(v_joint_max),0.0,0)
moveJoint(collision_traj_q5,0.5 * getMaxValue(a_joint_max),0.5 * getMaxValue(v_joint_max),0.0,0)
sleep(0)
stopRecord()
setTimeOptimalEnable(true)
str1 = getRobotType()
str2 = getRobotSubType()
if str2 ~= "" and str2 ~= "10" then
   trace_file = str1 .. "_" .. str2 .. "_" .. serial
else
   trace_file = str1 .. "_" .. serial
end
createFolder("/root/.arcs_test/collision_traj_temp/"..trace_file)
moveFolder("/root/arcs_ws/log/.trace/"..record_name ,"/root/.arcs_test/collision_traj_temp/"..trace_file.."/"..record_name)
filename = "nopayload_timeoptimalon"
str1 = getRobotType()
str2 = getRobotSubType()
if str2 ~= "" and str2 ~= "10" then
    robot_type = str1 .. "_" .. str2
else
    robot_type = str1
end
local record_name =robot_type  .. "_" .. filename .. ".csv"

poseO = {0.2 * wingspan,0,0.5 * wingspan,-3.14,0,1.57}
poseA = {0.5 * wingspan, -0.5 * wingspan, 0.5 * wingspan, 3.14, 0, 1.57}
local poseB = {0.5 * wingspan, -0.5 * wingspan, 0.2 * wingspan, 3.14, 0, 1.57}
local poseC = {0.5 * wingspan, 0.5 * wingspan, 0.2 * wingspan, 3.14, 0, 1.57}
local poseD = {0.5 * wingspan, 0.5 * wingspan, 0.5 * wingspan, 3.14, 0, 1.57}

local poseO1 = {-0.2 * wingspan, 0, 0.5 * wingspan, 3.14, 0, -1.57}
local poseA1 = {-0.5 * wingspan, -0.5 * wingspan, 0.5 * wingspan, 3.14, 0, -1.57}
local poseB1 = {-0.5 * wingspan, -0.5 * wingspan, 0.2 * wingspan, 3.14, 0, -1.57}
local poseC1 = {-0.5 * wingspan, 0.5 * wingspan, 0.2 * wingspan, 3.14, 0, -1.57}
local poseD1 = {-0.5 * wingspan, 0.5 * wingspan, 0.5 * wingspan, 3.14, 0, -1.57}

local poseE = {0.8 * wingspan, 0.5 * wingspan, 0.2 * wingspan, 3.14, 0, 1.57}
local poseF = {0.5 * wingspan, 0.8 * wingspan, 0.2 * wingspan, 3.14, 0, 1.57}
local poseG = {0.8 * wingspan, 0.5 * wingspan, 0.2 * wingspan, 3.14, 0, 1.57}
local poseH = {0.5 * wingspan, -0.8 * wingspan, 0.2 * wingspan, 3.14, 0, 1.57}
local qnear = getJointPositions()
-- 
local qO = {43.33 * M_PI / 180.0 ,50.67 * M_PI / 180.0,116.09 * M_PI / 180.0,-24.59 * M_PI / 180.0,90 * M_PI / 180.0,43.33 * M_PI / 180.0}
local qA = inverseKinematics(qnear,poseA)
local qB = inverseKinematics(qnear,poseB)
local qC = inverseKinematics(qnear,poseC)
local qD = inverseKinematics(qnear,poseD)
local qO1 =  {-43.33 * M_PI / 180.0 ,-50.67 * M_PI / 180.0,-116.09 * M_PI / 180.0,24.59 * M_PI / 180.0,-90 * M_PI / 180.0,-43.33 * M_PI / 180.0}
local qA1 = inverseKinematics(qnear,poseA1)
local qB1 = inverseKinematics(qnear,poseB1)
local qC1 = inverseKinematics(qnear,poseC1)
local qD1 = inverseKinematics(qnear,poseD1)

local qE = {-49.64 * M_PI / 180.0 ,-58.23 * M_PI / 180.0,38.81 * M_PI / 180.0,7.04 * M_PI / 180.0,90.0 * M_PI / 180.0,-49.96 * M_PI / 180.0}
local qF = {-23.52 * M_PI / 180.0 ,-58.27 * M_PI / 180.0,38.81 * M_PI / 180.0,7.04 * M_PI / 180.0,90.0 * M_PI / 180.0,-23.83 * M_PI / 180.0}
local qG = {40.66 * M_PI / 180.0 ,-59.55 * M_PI / 180.0,38.75 * M_PI / 180.0,8.29 * M_PI / 180.0,90.0 * M_PI / 180.0,40.41 * M_PI / 180.0}
local qH = {69 * M_PI / 180.0 ,-54.36 * M_PI / 180.0,49.29 * M_PI / 180.0,13.65 * M_PI / 180.0,90.0 * M_PI / 180.0,68.68 * M_PI / 180.0}

-- laohua
sleep(0)
startRecord(record_name)
moveJoint(laohuaq1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0,0)
moveJoint(laohuaq2,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0,0)
moveJoint(laohuaq3,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0,0)
moveJoint(laohuaq4,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0,0)
moveJoint(laohuaq5,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0,0)
moveJoint(laohuaq6,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0,0)
moveJoint(laohuaq7,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0,0)
moveJoint(laohuaq8,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0,0)


-- laohua blend1mm
moveJoint(laohuaq1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
moveJoint(laohuaq2,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
moveJoint(laohuaq3,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
moveJoint(laohuaq4,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
moveJoint(laohuaq5,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
moveJoint(laohuaq6,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
moveJoint(laohuaq7,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
moveJoint(laohuaq8,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)

-- O->A->B->C->D->O->O'

sleep(0)
moveJoint(qO,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0,0)
sleep(0)
moveLine(poseA,a_tcp_max,v_tcp_max,0,0)
sleep(0)
qA = getJointPositions()
moveLine(poseB,a_tcp_max,v_tcp_max,0,0)
sleep(0)
qB = getJointPositions()
moveLine(poseC,a_tcp_max,v_tcp_max,0,0)
sleep(0)
qC = getJointPositions()
moveLine(poseD,a_tcp_max,v_tcp_max,0,0)
sleep(0)
qD = getJointPositions()

moveJoint(qO,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
sleep(0)

moveJoint(qO1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
sleep(0)
-- O'->A'->B'->C'->D'
moveLine(poseA1,a_tcp_max,v_tcp_max,0.001,0)
sleep(0)
qA1 = getJointPositions()
moveLine(poseB1,a_tcp_max,v_tcp_max,0.001,0)
sleep(0)
qB1 = getJointPositions()
moveLine(poseC1,a_tcp_max,v_tcp_max,0.001,0)
sleep(0)
qC1 = getJointPositions()
moveLine(poseD1,a_tcp_max,v_tcp_max,0.001,0)
sleep(0)
qD1 = getJointPositions()

moveJoint(qO,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
sleep(0)
moveLine(poseA,a_tcp_max,v_tcp_max,0.001,0)
moveLine(poseB,a_tcp_max,v_tcp_max,0.001,0)
moveLine(poseC,a_tcp_max,v_tcp_max,0.001,0)
moveLine(poseD,a_tcp_max,v_tcp_max,0.001,0)

moveJoint(qO,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
sleep(0)

moveJoint(qO1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
sleep(0)
moveLine(poseA1,a_tcp_max,v_tcp_max,0.001,0)
moveLine(poseB1,a_tcp_max,v_tcp_max,0.001,0)
moveLine(poseC1,a_tcp_max,v_tcp_max,0.001,0)
moveLine(poseD1,a_tcp_max,v_tcp_max,0.001,0)

-- O->A->B->C->D->O->O'->A'->B'->C'->D'->O'->O
moveJoint(qO1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
moveJoint(qO,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
moveJoint(qA,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
moveJoint(qB,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
moveJoint(qC,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
moveJoint(qD,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
moveJoint(qO,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)

moveJoint(qO1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
moveJoint(qA1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
moveJoint(qB1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
moveJoint(qC1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
moveJoint(qD1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
moveJoint(qO1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)

moveJoint(qO,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
moveJoint(qA,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
moveJoint(qB,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
moveJoint(qC,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
moveJoint(qD,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
moveJoint(qO,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)

moveJoint(qO1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
moveJoint(qA1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
moveJoint(qB1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
moveJoint(qC1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
moveJoint(qD1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
moveJoint(qO,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)

sleep(0.5)

-- E->F->G->H      moveJ
moveJoint(qE,0.5*getMaxValue(a_joint_max),0.5*getMaxValue(v_joint_max),0,0)
sleep(1)
moveJoint(qE,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
moveJoint(qF,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
moveJoint(qG,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
moveJoint(qH,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
moveJoint(qE,0.5*getMaxValue(a_joint_max),0.5*getMaxValue(v_joint_max),0,0)
sleep(0.5)


-- E->F->G->H      moveJ
moveJoint(qE,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0,0)
sleep(0)
poseE = getTcpPose()
moveJoint(qF,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0,0)
sleep(0)
poseF = getTcpPose()
moveJoint(qG,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0,0)
sleep(0)
poseG = getTcpPose()
moveJoint(qH,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0,0)
sleep(0)
poseH = getTcpPose()
moveJoint(qE,0.5*getMaxValue(a_joint_max),0.5*getMaxValue(v_joint_max),0,0)
sleep(0.5)


-- E->F->G->H      moveL
moveLine(poseE,a_tcp_max,v_tcp_max,0,0)
moveLine(poseF,a_tcp_max,v_tcp_max,0,0)
moveLine(poseG,a_tcp_max,v_tcp_max,0,0)
moveLine(poseH,a_tcp_max,v_tcp_max,0,0)
moveJoint(qE,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0,0)
sleep(0.5)

-- E->F->G->H      moveL
moveLine(poseE,a_tcp_max,v_tcp_max,0.001,0)
moveLine(poseF,a_tcp_max,v_tcp_max,0.001,0)
moveLine(poseG,a_tcp_max,v_tcp_max,0.001,0)
moveLine(poseH,a_tcp_max,v_tcp_max,0.001,0)
sleep(0)
stopRecord()
sleep(1)



str1 = getRobotType()
str2 = getRobotSubType()
if str2 ~= "" and str2 ~= "10" then
   trace_file = str1 .. "_" .. str2 .. "_" .. serial
else
   trace_file = str1 .. "_" .. serial
end
createFolder("/root/.arcs_test/collision_traj_temp/"..trace_file)
moveFolder("/root/arcs_ws/log/.trace/"..record_name ,"/root/.arcs_test/collision_traj_temp/"..trace_file.."/"..record_name)

