--- filename: get_collision_data_new.lua
--- Auto generated by 'aubo_scope' v0.32.0-alpha.261 2025-11-04 10:38:02
--- DO NOT MODIFY IT!
local app = {}
local aubo = require('aubo')
local sched = sched or aubo.sched
local math = aubo.math or math
local realtime = aubo.realtime or realtime

local sleep = sched.sleep
local thread = sched.thread
local sync = sched.sync
local run = sched.run
local kill = sched.kill
local halt = sched.halt

app.PRIORITY = 1000 -- set the app priority, which determines app execution order
app.VERSION = "0.1"
app.VENDOR = "Aubo Robotics"

function p_get_collision_data_new()
    local _ENV = sched.select_robot(1)
    local lang = "zh_CN"
    local __VAR = {}
    local fc = require('aubo.force_control')
    setCollisionStopType(1)
    setCollisionLevel(6)
    setFreedriveDamp({0.5,0.5,0.5,0.5,0.5,0.5})
    INF = 9999
    setHomePosition({0,-0.2617993877991494,1.74532925199433,0.4363323129985824,1.570796326794897,0}    )
    setDigitalInputActionDefault()
    setDigitalOutputRunstateDefault()
    setPayload(0, {0,0,0}, {0,0,0}, {0,0,0,0,0,0,0,0,0})
    setTcpOffset({0,0,0,0,0,0})
    setToolVoltageOutputDomain(0)
    setToolIoInput(0, true)
    setToolIoInput(1, true)
    setToolIoInput(2, true)
    setToolIoInput(3, true)
    selectTcpForceSensor("")
    Base= {0,0,0,0,0,0}
    Tool= {0,0,0,0,0,0}
    setLabel(1, "初始变量")
    u88c5u914du70b9_p = {0.5021140750196728,-0.1212639714929334,0.302698634000462,-0.3433462199736826,-0.008117814200158913,-1.569923464900126}    
    u88c5u914du70b9_q = {0,-0.261799,2.095350210541387,0.436332,-1.5751630642,0}    
    
    setLabel(2, "在开始之前")
    setLabel(3, "serial = getHardwareCustomParameters(\"get_robot_serial\")")
    --subscript context start
    serial = getHardwareCustomParameters("get_robot_serial")
    --subscript context end
    
    setLabel(4, "trajRun.lua")
    --subscript context start
    waitForMotionComplete = function()
        while (getQueueSize() > 0) or (isSteady() == false) do
            sync()
        end
    end
    function createFolder(path)	
        os.execute("mkdir -p "..path)
    end
    function moveFolder(file,topath)
        os.execute("mv ".. file .. " " .. topath)
    end
    function  parseThreshold(file_name)
        local str = ""
        indx = 0
        local robot_type = getRobotType()
        local robot_subtype = getRobotSubType()  
        local robot_name 
        if robot_subtype == "" or robot_subtype == "10" then
            robot_name = robot_type
        else
            robot_name = robot_type .. "_" .. robot_subtype
        end
        local file = io.open(file_name, "r")
        if file == nil then
            textmsg("碰撞阈值文件为空： ")
             sched.sync_program_point()
             clearNamedVariable("_popup_continue_or_stop")
             do
                local _popup_t = getControlSystemTime()
                popup(TraceLevel.ERROR, "Error", str_cat(table_to_str(robot_name),"的碰撞阈值计算失败,联系研发人员介入"), 1)
                while not variableUpdated("_popup_continue_or_stop", _popup_t) do sync() end
                if not getBool("_popup_continue_or_stop", true) then halt() end
            end
            halt()
        end
        local line = file:read()
        local reps = ","
        local i = 1
        while line do
            indx = indx + 1	   
            string.gsub(line,'[^'..reps..']+',function (w)
                  str = str .. w
                  if i ~= 18 then
                      str = str .. ","
                  end
                  i = i + 1
            end)
            line = file:read()
        end
        if indx ~= 3 then
            textmsg("err: 阈值计算结果为空...")
            sched.sync_program_point()
             clearNamedVariable("_popup_continue_or_stop")
             do
                local _popup_t = getControlSystemTime()
                popup(TraceLevel.ERROR, "Error", str_cat(table_to_str(robot_name),"的碰撞阈值计算失败,联系研发人员介入"), 1)
                while not variableUpdated("_popup_continue_or_stop", _popup_t) do sync() end
                if not getBool("_popup_continue_or_stop", true) then halt() end
            end
            halt()
        end
        return str
    end
    key = ""
    function PrintTable(table , level)
      level = level or 1
      local indent = ""
      for i = 1, level do
        indent = indent.."  "
      end
      if key ~= "" then
        print(indent..key.." ".."=".." ".."{")
      else
        print(indent .. "{")
      end
      key = ""
      for k,v in pairs(table) do
         if type(v) == "table" then
            key = k
            PrintTable(v, level + 1)
         else
            local content = string.format("%s%s = %s", indent .. "  ",tostring(k), tostring(v))
          print(content)  
          end
      end
      print(indent .. "}")
    end
    function min(a1,b1)
        if(a1>=b1)
        then
            return b1
        else
            return a1
        end
    end
    function isBufferValid()
        local max_retry_count = 10
        local cnt = 0
        local isValid = pathBufferValid("rec")
        while(not isValid) do
            if(cnt>max_retry_count)
            then
                return -1
            end
            isValid =  pathBufferValid("rec")
            cnt = cnt + 1
            sleep(0.5)
        end
        return 0
    end
    function parseTraj(file)
        local traj_table = {}
        indx = 0
        local line = file:read()
        local reps = ","
        while line do
            indx = indx + 1
    	    local line_table = {} 
            string.gsub(line,'[^'..reps..']+',function (w)
                  table.insert(line_table,tonumber(w))
            end)
            traj_table[indx] = line_table
            line = file:read()
        end
        return traj_table
    end
    function runTraj(traj_name, record_name)
        local file = io.open(traj_name, "r")
        if file == nil then
             textmsg("轨迹文件为空： "..record_name)
             sched.sync_program_point()
             clearNamedVariable("_popup_continue_or_stop")
             do
                local _popup_t = getControlSystemTime()
                popup(TraceLevel.ERROR, "Error", str_cat(table_to_str(robot_type),"的轨迹文件为空,联系研发人员导入"), 1)
                while not variableUpdated("_popup_continue_or_stop", _popup_t) do sync() end
                if not getBool("_popup_continue_or_stop", true) then halt() end
            end
            
            halt()
        end
        local traj = parseTraj(file)
        local traj_sz = #traj
        if(traj_sz == 0)
        then
            print("轨迹文件中的路点数量为0")
            return 0
        else
            print(" 加载的路点数量为: ", traj_sz)
        end
        PrintTable(traj[1],1)
        setSpeedFraction(1.0)
        moveJoint(traj[1], 30 * (3.14 / 180), 30 * (3.14 / 180), 0., 0.)
        waitForMotionComplete()
        print("关节运动到轨迹文件中的第一个路点成功")
       -- start()
       -- tmp, lineno, comment = getPlanContext()
       -- local task_id = newTask()
        --setPlanContext(task_id, lineno, comment)
        pathBufferFree("rec")
        pathBufferAlloc("rec", 2, traj_sz)
        -- 将轨迹文件中的路点分组添加到路径缓存中，
        -- 以10个点为1组，
        -- 如果未添加的路点数量小于或者等于10时，则作为最后一组来添加
        local beg = 0
        while 1 do
            local path_table = {}
            local end_pt = min(10,traj_sz-beg)
            for i=1,end_pt do
                path_table[i] = traj[beg+i]
            end
            pathBufferAppend("rec", path_table)
            beg = beg+10
            if(end_pt<10)
            then 
                break
            end
        end      
        
        local interval = 0.005
        pathBufferEval("rec", getJointMaxAccelerations(),getJointMaxSpeeds(),interval)
        local isBufValid = isBufferValid()
        if(isBufValid==-1)
        then
            print("路径缓存无效，无法进行轨迹运动")
        else
            startRecord(record_name)
            movePathBuffer("rec")
            waitForMotionComplete()
        end
        stopRecord()
        str1 = getRobotType()
        str2 = getRobotSubType()
        if str2 ~= "" and str2 ~= "10" then
            trace_file = str1 .. "_" .. str2 .. "_" .. serial
        else
            trace_file = str1 .. "_" .. serial
        end
        createFolder("/root/.arcs_test/collision_traj_temp/"..trace_file)
        moveFolder("/root/arcs_ws/log/.trace/"..record_name ,"/root/.arcs_test/collision_traj_temp/"..trace_file.."/"..record_name)
      --  stop()
      --  deleteTask(task_id)
    end
    --subscript context end
    sleep(0)
    setLabel(5, "机器人编程")
    setSpeedFraction(1)
    setLabel(6, "设置负载：0.000/[0.00,0.00,0.00]")
    setPayload(0,{0,0,0},{0,0,0},{0.0,0.0,0.0,0.0,0.0,0.0})
    
    setLabel(7, "runTraj_nopayload.lua")
    --subscript context start
    function getMaxValue(arr)
        if #arr == 0 then
            return nil  -- 空数组返回nil
        end
        
        local maxVal = arr[1]
        for i = 2, #arr do
            if arr[i] > maxVal then
                maxVal = arr[i]
            end
        end
        return maxVal
    end
    local laohuaq1 = {-0.8900944451586199,0.7754199448783765,0.8449337445890255,-1.402323799030817,0.5244949971154704,-0.5768120810148624}
    local laohuaq2 = {-1.500097632770998,1.468678032144206,1.69941094027469,-0.7901225835097961,1.152255987571724,-1.570954052000511}
    local laohuaq3 = {-5.204962099546476e-05,4.898787858396683e-05,5.817310581846062e-05,-3.301225233783409e-05,4.768436448798257e-05,-5.50204205630568e-05}
    local laohuaq4 = {1.085406055330484,-1.076851547032759,-1.305141184718867,1.416317325994021,-0.7297101617315598,0.6265652133160159}
    local laohuaq5 = {1.507409073649655,-1.459238680289558,-1.796954991762602,0.722440130161161,-1.142462352711499,1.407899201647873}
    local laohuaq6 = {6.123484822995854e-06,-6.123484822995854e-06,-6.123484822995854e-06,3.668028037537121e-06,-3.668028037537121e-06,0}
    local laohuaq7 = {2.094393975501891,1.570794073012288,2.094393975501891,2.094391052278904,1.570794976756799,1.570794976756799}
    local laohuaq8 = {-2.094395102393196,-1.570795199903593,-2.094395102393196,-2.094396452431293,-1.570796326794897,-1.570796326794897}
    local collision_traj_q1 = {-0.7515378578828522,-0.7986609376638408,-1.943945506808805,-0.4316205300352991,-1.567304994938573,-0.7461265718467387}
    local collision_traj_q2 = {-0.5916406956946124,-0.4383168690013916,0.9346367748086962,-0.2057141884466272,1.577519749858617,-0.5936897035162078}
    local collision_traj_q3 = {-0.5922077116954151,-0.5380536335044741,1.514432236238922,0.4738717056678277,1.576837980619557,-0.5896613731728219}
    local collision_traj_q4 = {-0.5916406956946124,-0.4383168690013916,0.9346367748086962,-0.2057141884466272,1.577519749858617,-0.5936897035162078}
    local collision_traj_q5 = {0.9833218486680861,-0.4400638182991024,0.9366010802400478,-0.2020158007473298,1.577528166762803,0.9812729908507238}
    filename = "nopayload"
    local filepath = "/root/arcs_ws/program/collision_traj/"
    str1 = getRobotType()
    str2 = getRobotSubType()
    if str2 ~= "" and str2 ~= "10" then
        robot_type = str1 .. "_" .. str2
    else
        robot_type = str1
    end
    local record_name =robot_type  .. "_" .. filename .. ".csv"
    local M_PI = 3.1415926535
     a_joint_max = getJointMaxAccelerations()
     v_joint_max = getJointMaxSpeeds()
    local a_tcp = getTcpMaxAccelerations()
    local a_tcp_max = a_tcp[1]
    local v_tcp = getTcpMaxSpeeds()
    local v_tcp_max = v_tcp[1]
    local dh = getKinematicsParam(true)
    local wingspan = dh.a[3] + dh.a[4] + dh.d[5]
    poseO = {0.2 * wingspan,0,0.5 * wingspan,-3.14,0,1.57}
    poseA = {0.5 * wingspan, -0.5 * wingspan, 0.5 * wingspan, 3.14, 0, 1.57}
    local poseB = {0.5 * wingspan, -0.5 * wingspan, 0.2 * wingspan, 3.14, 0, 1.57}
    local poseC = {0.5 * wingspan, 0.5 * wingspan, 0.2 * wingspan, 3.14, 0, 1.57}
    local poseD = {0.5 * wingspan, 0.5 * wingspan, 0.5 * wingspan, 3.14, 0, 1.57}
    local poseO1 = {-0.2 * wingspan, 0, 0.5 * wingspan, 3.14, 0, -1.57}
    local poseA1 = {-0.5 * wingspan, -0.5 * wingspan, 0.5 * wingspan, 3.14, 0, -1.57}
    local poseB1 = {-0.5 * wingspan, -0.5 * wingspan, 0.2 * wingspan, 3.14, 0, -1.57}
    local poseC1 = {-0.5 * wingspan, 0.5 * wingspan, 0.2 * wingspan, 3.14, 0, -1.57}
    local poseD1 = {-0.5 * wingspan, 0.5 * wingspan, 0.5 * wingspan, 3.14, 0, -1.57}
    local poseE = {0.8 * wingspan, 0.5 * wingspan, 0.2 * wingspan, 3.14, 0, 1.57}
    local poseF = {0.5 * wingspan, 0.8 * wingspan, 0.2 * wingspan, 3.14, 0, 1.57}
    local poseG = {0.8 * wingspan, 0.5 * wingspan, 0.2 * wingspan, 3.14, 0, 1.57}
    local poseH = {0.5 * wingspan, -0.8 * wingspan, 0.2 * wingspan, 3.14, 0, 1.57}
    local qnear = getJointPositions()
    -- 
    local qO = {43.33 * M_PI / 180.0 ,50.67 * M_PI / 180.0,116.09 * M_PI / 180.0,-24.59 * M_PI / 180.0,90 * M_PI / 180.0,43.33 * M_PI / 180.0}
    local qA = inverseKinematics(qnear,poseA)
    local qB = inverseKinematics(qnear,poseB)
    local qC = inverseKinematics(qnear,poseC)
    local qD = inverseKinematics(qnear,poseD)
    local qO1 =  {-43.33 * M_PI / 180.0 ,-50.67 * M_PI / 180.0,-116.09 * M_PI / 180.0,24.59 * M_PI / 180.0,-90 * M_PI / 180.0,-43.33 * M_PI / 180.0}
    local qA1 = inverseKinematics(qnear,poseA1)
    local qB1 = inverseKinematics(qnear,poseB1)
    local qC1 = inverseKinematics(qnear,poseC1)
    local qD1 = inverseKinematics(qnear,poseD1)
    local qE = {-49.64 * M_PI / 180.0 ,-58.23 * M_PI / 180.0,38.81 * M_PI / 180.0,7.04 * M_PI / 180.0,90.0 * M_PI / 180.0,-49.96 * M_PI / 180.0}
    local qF = {-23.52 * M_PI / 180.0 ,-58.27 * M_PI / 180.0,38.81 * M_PI / 180.0,7.04 * M_PI / 180.0,90.0 * M_PI / 180.0,-23.83 * M_PI / 180.0}
    local qG = {40.66 * M_PI / 180.0 ,-59.55 * M_PI / 180.0,38.75 * M_PI / 180.0,8.29 * M_PI / 180.0,90.0 * M_PI / 180.0,40.41 * M_PI / 180.0}
    local qH = {69 * M_PI / 180.0 ,-54.36 * M_PI / 180.0,49.29 * M_PI / 180.0,13.65 * M_PI / 180.0,90.0 * M_PI / 180.0,68.68 * M_PI / 180.0}
    -- laohua
    sleep(0)
    startRecord(record_name)
    moveJoint(laohuaq1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0,0)
    moveJoint(laohuaq2,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0,0)
    moveJoint(laohuaq3,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0,0)
    moveJoint(laohuaq4,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0,0)
    moveJoint(laohuaq5,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0,0)
    moveJoint(laohuaq6,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0,0)
    moveJoint(laohuaq7,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0,0)
    moveJoint(laohuaq8,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0,0)
    -- laohua blend1mm
    moveJoint(laohuaq1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
    moveJoint(laohuaq2,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
    moveJoint(laohuaq3,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
    moveJoint(laohuaq4,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
    moveJoint(laohuaq5,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
    moveJoint(laohuaq6,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
    moveJoint(laohuaq7,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
    moveJoint(laohuaq8,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
    -- O->A->B->C->D->O->O'
    sleep(0)
    moveJoint(qO,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0,0)
    sleep(0)
    moveLine(poseA,a_tcp_max,v_tcp_max,0,0)
    sleep(0)
    qA = getJointPositions()
    moveLine(poseB,a_tcp_max,v_tcp_max,0,0)
    sleep(0)
    qB = getJointPositions()
    moveLine(poseC,a_tcp_max,v_tcp_max,0,0)
    sleep(0)
    qC = getJointPositions()
    moveLine(poseD,a_tcp_max,v_tcp_max,0,0)
    sleep(0)
    qD = getJointPositions()
    moveJoint(qO,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
    sleep(0)
    moveJoint(qO1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
    sleep(0)
    -- O'->A'->B'->C'->D'
    moveLine(poseA1,a_tcp_max,v_tcp_max,0.001,0)
    sleep(0)
    qA1 = getJointPositions()
    moveLine(poseB1,a_tcp_max,v_tcp_max,0.001,0)
    sleep(0)
    qB1 = getJointPositions()
    moveLine(poseC1,a_tcp_max,v_tcp_max,0.001,0)
    sleep(0)
    qC1 = getJointPositions()
    moveLine(poseD1,a_tcp_max,v_tcp_max,0.001,0)
    sleep(0)
    qD1 = getJointPositions()
    moveJoint(qO,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
    sleep(0)
    moveLine(poseA,a_tcp_max,v_tcp_max,0.001,0)
    moveLine(poseB,a_tcp_max,v_tcp_max,0.001,0)
    moveLine(poseC,a_tcp_max,v_tcp_max,0.001,0)
    moveLine(poseD,a_tcp_max,v_tcp_max,0.001,0)
    moveJoint(qO,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
    sleep(0)
    moveJoint(qO1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
    sleep(0)
    moveLine(poseA1,a_tcp_max,v_tcp_max,0.001,0)
    moveLine(poseB1,a_tcp_max,v_tcp_max,0.001,0)
    moveLine(poseC1,a_tcp_max,v_tcp_max,0.001,0)
    moveLine(poseD1,a_tcp_max,v_tcp_max,0.001,0)
    -- O->A->B->C->D->O->O'->A'->B'->C'->D'->O'->O
    moveJoint(qO1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
    moveJoint(qO,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
    moveJoint(qA,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
    moveJoint(qB,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
    moveJoint(qC,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
    moveJoint(qD,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
    moveJoint(qO,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
    moveJoint(qO1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
    moveJoint(qA1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
    moveJoint(qB1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
    moveJoint(qC1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
    moveJoint(qD1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
    moveJoint(qO1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
    moveJoint(qO,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
    moveJoint(qA,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
    moveJoint(qB,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
    moveJoint(qC,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
    moveJoint(qD,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
    moveJoint(qO,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
    moveJoint(qO1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
    moveJoint(qA1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
    moveJoint(qB1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
    moveJoint(qC1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
    moveJoint(qD1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
    -- E->F->G->H      moveL
    --moveJoint({0,0,0,0,0,0},0.5*getMaxValue(a_joint_max),0.5*getMaxValue(v_joint_max),0,0)
    sleep(0)
    moveJoint(qE,0.5*getMaxValue(a_joint_max),0.5*getMaxValue(v_joint_max),0,0)
    --moveLine(poseE,a_tcp_max,v_tcp_max,0,0)
    --moveLine(poseF,a_tcp_max,v_tcp_max,0,0)
    --moveLine(poseG,a_tcp_max,v_tcp_max,0,0)
    --moveLine(poseH,a_tcp_max,v_tcp_max,0,0)
    sleep(1)
    -- E->F->G->H      moveJ
    moveJoint(qE,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0,0)
    sleep(0)
    poseE = getTcpPose()
    moveJoint(qF,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0,0)
    sleep(0)
    poseF = getTcpPose()
    moveJoint(qG,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0,0)
    sleep(0)
    poseG = getTcpPose()
    moveJoint(qH,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0,0)
    sleep(0)
    poseH = getTcpPose()
    moveJoint(qE,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0,0)
    -- E->F->G->H      moveL
    sleep(0)
    --moveJoint({0,0,0,0,0,0},getMaxValue(a_joint_max),getMaxValue(v_joint_max),0,0)
    moveJoint(qE,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
    sleep(0)
    moveJoint(qF,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
    moveJoint(qG,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
    moveJoint(qH,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
    moveJoint(qE,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
    moveLine(poseE,a_tcp_max,v_tcp_max,0,0)
    moveLine(poseF,a_tcp_max,v_tcp_max,0,0)
    moveLine(poseG,a_tcp_max,v_tcp_max,0,0)
    moveLine(poseH,a_tcp_max,v_tcp_max,0,0)
    moveJoint(qE,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0,0)
    sleep(0)
    -- E->F->G->H      moveL
    moveLine(poseE,a_tcp_max,v_tcp_max,0.001,0)
    moveLine(poseF,a_tcp_max,v_tcp_max,0.001,0)
    moveLine(poseG,a_tcp_max,v_tcp_max,0.001,0)
    moveLine(poseH,a_tcp_max,v_tcp_max,0.001,0)
    sleep(0)
    stopRecord()
    str1 = getRobotType()
    str2 = getRobotSubType()
    if str2 ~= "" and str2 ~= "10" then
       trace_file = str1 .. "_" .. str2 .. "_" .. serial
    else
       trace_file = str1 .. "_" .. serial
    end
    createFolder("/root/.arcs_test/collision_traj_temp/"..trace_file)
    moveFolder("/root/arcs_ws/log/.trace/"..record_name ,"/root/.arcs_test/collision_traj_temp/"..trace_file.."/"..record_name)
    --subscript context end
    
    setLabel(8, "关节运动")
    setLabel(9, "装配点")
    moveJoint(inverseKinematics(u88c5u914du70b9_q, u88c5u914du70b9_p), 1.39626, 1.0472, 0, 0)
    
    setLabel(10, "弹窗 警告：注:点击确认前安装负载, 运行带载轨迹")
    sched.sync_program_point()
    clearNamedVariable("_popup_continue_or_stop")
    do
        __VAR._popup_t = getControlSystemTime()
        popup(TraceLevel.WARNING, "Warning", "注:点击确认前安装负载, 运行带载轨迹", 1)
        while not variableUpdated("_popup_continue_or_stop", __VAR._popup_t) do sync() end
        if not getBool("_popup_continue_or_stop", true) then halt() end
    end
    
    setLabel(11, "设置负载：4.890/[0.00,130.00,50.00]")
    setPayload(4.89,{0,0.13,0.05},{0,0,0},{0.0,0.0,0.0,0.0,0.0,0.0})
    
    setLabel(12, "runTraj_payload.lua")
    --subscript context start
    function getMaxValue(arr)
        if #arr == 0 then
            return nil  -- 空数组返回nil
        end
        
        local maxVal = arr[1]
        for i = 2, #arr do
            if arr[i] > maxVal then
                maxVal = arr[i]
            end
        end
        return maxVal
    end
    local laohuaq1 = {-0.8900944451586199,0.7754199448783765,0.8449337445890255,-1.402323799030817,0.5244949971154704,-0.5768120810148624}
    local laohuaq2 = {-1.500097632770998,1.468678032144206,1.69941094027469,-0.7901225835097961,1.152255987571724,-1.570954052000511}
    local laohuaq3 = {-5.204962099546476e-05,4.898787858396683e-05,5.817310581846062e-05,-3.301225233783409e-05,4.768436448798257e-05,-5.50204205630568e-05}
    local laohuaq4 = {1.085406055330484,-1.076851547032759,-1.305141184718867,1.416317325994021,-0.7297101617315598,0.6265652133160159}
    local laohuaq5 = {1.507409073649655,-1.459238680289558,-1.796954991762602,0.722440130161161,-1.142462352711499,1.407899201647873}
    local laohuaq6 = {6.123484822995854e-06,-6.123484822995854e-06,-6.123484822995854e-06,3.668028037537121e-06,-3.668028037537121e-06,0}
    local laohuaq7 = {2.094393975501891,1.570794073012288,2.094393975501891,2.094391052278904,1.570794976756799,1.570794976756799}
    local laohuaq8 = {-2.094395102393196,-1.570795199903593,-2.094395102393196,-2.094396452431293,-1.570796326794897,-1.570796326794897}
    local collision_traj_q1 = {-0.7515378578828522,-0.7986609376638408,-1.943945506808805,-0.4316205300352991,-1.567304994938573,-0.7461265718467387}
    local collision_traj_q2 = {-0.5916406956946124,-0.4383168690013916,0.9346367748086962,-0.2057141884466272,1.577519749858617,-0.5936897035162078}
    local collision_traj_q3 = {-0.5922077116954151,-0.5380536335044741,1.514432236238922,0.4738717056678277,1.576837980619557,-0.5896613731728219}
    local collision_traj_q4 = {-0.5916406956946124,-0.4383168690013916,0.9346367748086962,-0.2057141884466272,1.577519749858617,-0.5936897035162078}
    local collision_traj_q5 = {0.9833218486680861,-0.4400638182991024,0.9366010802400478,-0.2020158007473298,1.577528166762803,0.9812729908507238}
    filename = "nopayload"
    local filepath = "/root/arcs_ws/program/collision_traj/"
    str1 = getRobotType()
    str2 = getRobotSubType()
    if str2 ~= "" and str2 ~= "10" then
        robot_type = str1 .. "_" .. str2
    else
        robot_type = str1
    end
    local record_name =robot_type  .. "_" .. filename .. ".csv"
    local M_PI = 3.1415926535
     a_joint_max = getJointMaxAccelerations()
     v_joint_max = getJointMaxSpeeds()
    local a_tcp = getTcpMaxAccelerations()
    local a_tcp_max = a_tcp[1]
    local v_tcp = getTcpMaxSpeeds()
    local v_tcp_max = v_tcp[1]
    local dh = getKinematicsParam(true)
    local wingspan = dh.a[3] + dh.a[4] + dh.d[5]
    poseO = {0.2 * wingspan,0,0.5 * wingspan,-3.14,0,1.57}
    poseA = {0.5 * wingspan, -0.5 * wingspan, 0.5 * wingspan, 3.14, 0, 1.57}
    local poseB = {0.5 * wingspan, -0.5 * wingspan, 0.2 * wingspan, 3.14, 0, 1.57}
    local poseC = {0.5 * wingspan, 0.5 * wingspan, 0.2 * wingspan, 3.14, 0, 1.57}
    local poseD = {0.5 * wingspan, 0.5 * wingspan, 0.5 * wingspan, 3.14, 0, 1.57}
    local poseO1 = {-0.2 * wingspan, 0, 0.5 * wingspan, 3.14, 0, -1.57}
    local poseA1 = {-0.5 * wingspan, -0.5 * wingspan, 0.5 * wingspan, 3.14, 0, -1.57}
    local poseB1 = {-0.5 * wingspan, -0.5 * wingspan, 0.2 * wingspan, 3.14, 0, -1.57}
    local poseC1 = {-0.5 * wingspan, 0.5 * wingspan, 0.2 * wingspan, 3.14, 0, -1.57}
    local poseD1 = {-0.5 * wingspan, 0.5 * wingspan, 0.5 * wingspan, 3.14, 0, -1.57}
    local poseE = {0.8 * wingspan, 0.5 * wingspan, 0.2 * wingspan, 3.14, 0, 1.57}
    local poseF = {0.5 * wingspan, 0.8 * wingspan, 0.2 * wingspan, 3.14, 0, 1.57}
    local poseG = {0.8 * wingspan, 0.5 * wingspan, 0.2 * wingspan, 3.14, 0, 1.57}
    local poseH = {0.5 * wingspan, -0.8 * wingspan, 0.2 * wingspan, 3.14, 0, 1.57}
    local qnear = getJointPositions()
    -- 
    local qO = {43.33 * M_PI / 180.0 ,50.67 * M_PI / 180.0,116.09 * M_PI / 180.0,-24.59 * M_PI / 180.0,90 * M_PI / 180.0,43.33 * M_PI / 180.0}
    local qA = inverseKinematics(qnear,poseA)
    local qB = inverseKinematics(qnear,poseB)
    local qC = inverseKinematics(qnear,poseC)
    local qD = inverseKinematics(qnear,poseD)
    local qO1 =  {-43.33 * M_PI / 180.0 ,-50.67 * M_PI / 180.0,-116.09 * M_PI / 180.0,24.59 * M_PI / 180.0,-90 * M_PI / 180.0,-43.33 * M_PI / 180.0}
    local qA1 = inverseKinematics(qnear,poseA1)
    local qB1 = inverseKinematics(qnear,poseB1)
    local qC1 = inverseKinematics(qnear,poseC1)
    local qD1 = inverseKinematics(qnear,poseD1)
    local qE = {-49.64 * M_PI / 180.0 ,-58.23 * M_PI / 180.0,38.81 * M_PI / 180.0,7.04 * M_PI / 180.0,90.0 * M_PI / 180.0,-49.96 * M_PI / 180.0}
    local qF = {-23.52 * M_PI / 180.0 ,-58.27 * M_PI / 180.0,38.81 * M_PI / 180.0,7.04 * M_PI / 180.0,90.0 * M_PI / 180.0,-23.83 * M_PI / 180.0}
    local qG = {40.66 * M_PI / 180.0 ,-59.55 * M_PI / 180.0,38.75 * M_PI / 180.0,8.29 * M_PI / 180.0,90.0 * M_PI / 180.0,40.41 * M_PI / 180.0}
    local qH = {69 * M_PI / 180.0 ,-54.36 * M_PI / 180.0,49.29 * M_PI / 180.0,13.65 * M_PI / 180.0,90.0 * M_PI / 180.0,68.68 * M_PI / 180.0}
    -- laohua
    sleep(0)
    startRecord(record_name)
    moveJoint(laohuaq1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0,0)
    moveJoint(laohuaq2,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0,0)
    moveJoint(laohuaq3,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0,0)
    moveJoint(laohuaq4,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0,0)
    moveJoint(laohuaq5,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0,0)
    moveJoint(laohuaq6,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0,0)
    moveJoint(laohuaq7,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0,0)
    moveJoint(laohuaq8,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0,0)
    -- laohua blend1mm
    moveJoint(laohuaq1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
    moveJoint(laohuaq2,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
    moveJoint(laohuaq3,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
    moveJoint(laohuaq4,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
    moveJoint(laohuaq5,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
    moveJoint(laohuaq6,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
    moveJoint(laohuaq7,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
    moveJoint(laohuaq8,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
    -- O->A->B->C->D->O->O'
    sleep(0)
    moveJoint(qO,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0,0)
    sleep(0)
    moveLine(poseA,a_tcp_max,v_tcp_max,0,0)
    sleep(0)
    qA = getJointPositions()
    moveLine(poseB,a_tcp_max,v_tcp_max,0,0)
    sleep(0)
    qB = getJointPositions()
    moveLine(poseC,a_tcp_max,v_tcp_max,0,0)
    sleep(0)
    qC = getJointPositions()
    moveLine(poseD,a_tcp_max,v_tcp_max,0,0)
    sleep(0)
    qD = getJointPositions()
    moveJoint(qO,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
    sleep(0)
    moveJoint(qO1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
    sleep(0)
    -- O'->A'->B'->C'->D'
    moveLine(poseA1,a_tcp_max,v_tcp_max,0.001,0)
    sleep(0)
    qA1 = getJointPositions()
    moveLine(poseB1,a_tcp_max,v_tcp_max,0.001,0)
    sleep(0)
    qB1 = getJointPositions()
    moveLine(poseC1,a_tcp_max,v_tcp_max,0.001,0)
    sleep(0)
    qC1 = getJointPositions()
    moveLine(poseD1,a_tcp_max,v_tcp_max,0.001,0)
    sleep(0)
    qD1 = getJointPositions()
    moveJoint(qO,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
    sleep(0)
    moveLine(poseA,a_tcp_max,v_tcp_max,0.001,0)
    moveLine(poseB,a_tcp_max,v_tcp_max,0.001,0)
    moveLine(poseC,a_tcp_max,v_tcp_max,0.001,0)
    moveLine(poseD,a_tcp_max,v_tcp_max,0.001,0)
    moveJoint(qO,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
    sleep(0)
    moveJoint(qO1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
    sleep(0)
    moveLine(poseA1,a_tcp_max,v_tcp_max,0.001,0)
    moveLine(poseB1,a_tcp_max,v_tcp_max,0.001,0)
    moveLine(poseC1,a_tcp_max,v_tcp_max,0.001,0)
    moveLine(poseD1,a_tcp_max,v_tcp_max,0.001,0)
    -- O->A->B->C->D->O->O'->A'->B'->C'->D'->O'->O
    moveJoint(qO1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
    moveJoint(qO,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
    moveJoint(qA,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
    moveJoint(qB,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
    moveJoint(qC,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
    moveJoint(qD,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
    moveJoint(qO,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
    moveJoint(qO1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
    moveJoint(qA1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
    moveJoint(qB1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
    moveJoint(qC1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
    moveJoint(qD1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
    moveJoint(qO1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
    moveJoint(qO,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
    moveJoint(qA,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
    moveJoint(qB,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
    moveJoint(qC,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
    moveJoint(qD,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
    moveJoint(qO,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
    moveJoint(qO1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.0,0)
    moveJoint(qA1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
    moveJoint(qB1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
    moveJoint(qC1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
    moveJoint(qD1,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
    -- E->F->G->H      moveL
    --moveJoint({0,0,0,0,0,0},0.5*getMaxValue(a_joint_max),0.5*getMaxValue(v_joint_max),0,0)
    sleep(0)
    moveJoint(qE,0.5*getMaxValue(a_joint_max),0.5*getMaxValue(v_joint_max),0,0)
    --moveLine(poseE,a_tcp_max,v_tcp_max,0,0)
    --moveLine(poseF,a_tcp_max,v_tcp_max,0,0)
    --moveLine(poseG,a_tcp_max,v_tcp_max,0,0)
    --moveLine(poseH,a_tcp_max,v_tcp_max,0,0)
    sleep(1)
    -- E->F->G->H      moveJ
    moveJoint(qE,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0,0)
    sleep(0)
    poseE = getTcpPose()
    moveJoint(qF,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0,0)
    sleep(0)
    poseF = getTcpPose()
    moveJoint(qG,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0,0)
    sleep(0)
    poseG = getTcpPose()
    moveJoint(qH,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0,0)
    sleep(0)
    poseH = getTcpPose()
    moveJoint(qE,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0,0)
    -- E->F->G->H      moveL
    sleep(0)
    --moveJoint({0,0,0,0,0,0},getMaxValue(a_joint_max),getMaxValue(v_joint_max),0,0)
    moveJoint(qE,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
    sleep(0)
    moveJoint(qF,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
    moveJoint(qG,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
    moveJoint(qH,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
    moveJoint(qE,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0.001,0)
    moveLine(poseE,a_tcp_max,v_tcp_max,0,0)
    moveLine(poseF,a_tcp_max,v_tcp_max,0,0)
    moveLine(poseG,a_tcp_max,v_tcp_max,0,0)
    moveLine(poseH,a_tcp_max,v_tcp_max,0,0)
    moveJoint(qE,getMaxValue(a_joint_max),getMaxValue(v_joint_max),0,0)
    sleep(0)
    -- E->F->G->H      moveL
    moveLine(poseE,a_tcp_max,v_tcp_max,0.001,0)
    moveLine(poseF,a_tcp_max,v_tcp_max,0.001,0)
    moveLine(poseG,a_tcp_max,v_tcp_max,0.001,0)
    moveLine(poseH,a_tcp_max,v_tcp_max,0.001,0)
    sleep(0)
    stopRecord()
    str1 = getRobotType()
    str2 = getRobotSubType()
    if str2 ~= "" and str2 ~= "10" then
       trace_file = str1 .. "_" .. str2 .. "_" .. serial
    else
       trace_file = str1 .. "_" .. serial
    end
    createFolder("/root/.arcs_test/collision_traj_temp/"..trace_file)
    moveFolder("/root/arcs_ws/log/.trace/"..record_name ,"/root/.arcs_test/collision_traj_temp/"..trace_file.."/"..record_name)
    --subscript context end
    
    setLabel(13, "弹窗 消息：带载轨迹运行完成, 点击确认按钮设置碰撞阈值...")
    sched.sync_program_point()
    clearNamedVariable("_popup_continue_or_stop")
    do
        __VAR._popup_t = getControlSystemTime()
        popup(TraceLevel.INFO, "Info", "带载轨迹运行完成, 点击确认按钮设置碰撞阈值...", 1)
        while not variableUpdated("_popup_continue_or_stop", __VAR._popup_t) do sync() end
        if not getBool("_popup_continue_or_stop", true) then halt() end
    end
    
    setLabel(14, "set_collision_threshold.lua")
    --subscript context start
    local str1 = getRobotType()
    local str2 = getRobotSubType()
    --获取版本号
    local version = getControlSoftwareFullVersion()
    local aubo_version = string.match(version, "(.-)%+")
    local robot_name
    if str2 == "" or str2 == "10" then
        robot_name = str1
    else
        robot_name = str1 .. "_" .. str2
    end
    local cmd = 'cd /opt/arcs/' .. aubo_version .. '/bin && ./cal_collision_threshold ' .. robot_name .. " " .. serial
    local path = "/root/.arcs_test/collision_traj_temp/"
    local file_path = path .. robot_name .. "_" .. serial .. "/" .. robot_name .. "_collisionThreshold.csv"
    textmsg("计算碰撞阈值...")
    local file = io.popen(cmd)
    file:close()
    local threshold_table = parseThreshold(file_path)
    --testmsg("设置碰撞阈值: " .. table.concat(threshold_table,","))
    threshold_str = "[base_collision_threshold]\ncollision_threshold = ["
    threshold_str = threshold_str .. threshold_table .. "]"
    textmsg("碰撞阈值计算完成,正在设置...")
    setHardwareCustomParameters(threshold_str)
    --subscript context end
end

function app:start(api)
  --
  self.api = api
  print("start---")
  p_get_collision_data_new()
end

function app:robot_error_handler(name, err)
  --
  print("An error hanppen to robot "..name)
end

-- return our app object
return app


